/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.mosp.common.common.BaseDao;
import jp.mosp.common.common.MospException;

import jp.mosp.payroll.dto.MKintaiDto;

public class MKintaiDao extends BaseDao {

	// e[uyуL[
	public static final String TABLE  		= "M_KINTAI";
	public static final String KEY_1 		= "KCODE";		//ЈR[h
	public static final String KEY_2 		= "SIKYUYM";	//xN

	// 
	public static final String COL_KCODE  			= "KCODE";			//ЈR[h
	public static final String COL_SIKYUYM  		= "SIKYUYM";		//xN
	public static final String COL_SNEN  			= "SNEN";			//xN
	public static final String COL_STUKI  			= "STUKI";			//x
	public static final String COL_SHI  			= "SHI";			//x
	public static final String COL_SNISSU  		= "SNISSU";			//oΓ
	public static final String COL_SKAISU  		= "SKAISU";			//oΉ
	public static final String COL_KINMUJI  		= "KINMUJI";		//Ζ
	public static final String COL_KYUKEIJI  		= "KYUKEIJI";		//xe
	public static final String COL_YUKYU  			= "YUKYU";			//L
	public static final String COL_TOKUKYU  		= "TOKUKYU";		//ʋx
	public static final String COL_KEKKIN  		= "KEKKIN";			//ʌΓ
	public static final String COL_SKEKKIN  		= "SKEKKIN";		//aΓ
	public static final String COL_DAIKYU  		= "DAIKYU";			//֋xɓ
	public static final String COL_FURIKAE  		= "FURIKAE";		//U֋xɓ
	public static final String COL_SONOTA  		= "SONOTA";			//̑xɓ
	public static final String COL_TISOKAI  		= "TISOKAI";		//xމ
	public static final String COL_TIJIKAN  		= "TIJIKAN";		//xގ
	public static final String COL_ZAJIKAN  		= "ZAJIKAN";		//ʎcƎ
	public static final String COL_KSJIKAN  		= "KSJIKAN";		//xcƎ
	public static final String COL_SNJIKAN  		= "SNJIKAN";		//[Ζ
	public static final String COL_KAIKIN  		= "KAIKIN";			//FΎ蓖x
	public static final String COL_SYOKUJIKAISU  	= "SYOKUJIKAISU";	//H蓖x
	public static final String COL_CYOKUKAISU1  	= "CYOKUKAISU1";	//1蓖x
	public static final String COL_CYOKUKAISU2  	= "CYOKUKAISU2";	//2蓖x
	public static final String COL_CYOKUKAISU3  	= "CYOKUKAISU3";	//3蓖x
	public static final String COL_HOKAKAISU1  	= "HOKAKAISU1";		//̑x1
	public static final String COL_HOKAKAISU2  	= "HOKAKAISU2";		//̑x2
	public static final String COL_HOKAKAISU3  	= "HOKAKAISU3";		//̑x3
	public static final String COL_HOKAKAISU4  	= "HOKAKAISU4";		//̑x4
	public static final String COL_HOKAKAISU5  	= "HOKAKAISU5";		//̑x5
	public static final String COL_SINSEIGAKU  	= "SINSEIGAKU";		//x\z
	public static final String COL_NIJIKYU  		= "NIJIKYU";		//񎞊ԔNx
	public static final String COL_WARIMASI1 		= "WARIMASI1";		//1.00

	/**
	 * RXgN^
	 */
	public MKintaiDao() {
		super();
	}

	/**
	 * ʎ擾(DTOList)
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MKintaiDto> mappingAll() throws SQLException {
		List<MKintaiDto> all = new ArrayList<MKintaiDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʎ擾(DTO)
	 * @return m_kintaiDto m_kintaiR[h
	 * @throws SQLException
	 */
	private MKintaiDto mapping() throws SQLException {
		MKintaiDto dto = new MKintaiDto();
		dto.setKCode 		(rs.getString (COL_KCODE)		);	//ЈR[h
		dto.setSikyuYM 		(rs.getString (COL_SIKYUYM)		);	//xN
		dto.setSNen 		(rs.getInt    (COL_SNEN)		);	//xN
		dto.setSTuki 		(rs.getInt    (COL_STUKI)		);	//x
		dto.setSHi 			(rs.getInt    (COL_SHI)			);	//x
		dto.setSNissu 		(rs.getDouble (COL_SNISSU)		);	//oΓ
		dto.setSKaisu 		(rs.getInt    (COL_SKAISU)		);	//oΉ
		dto.setKinmuJi 		(rs.getInt    (COL_KINMUJI)		);	//Ζ
		dto.setKyukeiJi 	(rs.getInt    (COL_KYUKEIJI)	);	//xe
		dto.setYukyu 		(rs.getDouble (COL_YUKYU)		);	//L
		dto.setTokuKyu	 	(rs.getDouble (COL_TOKUKYU)		);	//ʋx
		dto.setKekkin 		(rs.getDouble (COL_KEKKIN)		);	//ʌΓ
		dto.setSKekkin 		(rs.getDouble (COL_SKEKKIN)		);	//aΓ
		dto.setDaiKyu 		(rs.getDouble (COL_DAIKYU)		);	//֋xɓ
		dto.setFurikae 		(rs.getDouble (COL_FURIKAE)		);	//U֋xɓ
		dto.setSonota		(rs.getInt 	  (COL_SONOTA)		);	//̑xɓ
		dto.setTiSoKai 		(rs.getInt    (COL_TISOKAI)		);	//xމ
		dto.setTiJikan 		(rs.getInt    (COL_TIJIKAN)		);	//xގ
		dto.setZaJikan 		(rs.getInt    (COL_ZAJIKAN)		);	//ʎcƎ
		dto.setKsJikan 		(rs.getInt    (COL_KSJIKAN)		);	//xcƎ
		dto.setSnJikan 		(rs.getInt    (COL_SNJIKAN)		);	//[Ζ
		dto.setKaikin 		(rs.getInt    (COL_KAIKIN)		);	//FΎ蓖x
		dto.setSyokujiKaisu (rs.getInt    (COL_SYOKUJIKAISU));	//H蓖x
		dto.setCyokuKaisu1 	(rs.getInt    (COL_CYOKUKAISU1)	);	//1蓖x
		dto.setCyokuKaisu2 	(rs.getInt    (COL_CYOKUKAISU2)	);	//2蓖x
		dto.setCyokuKaisu3 	(rs.getInt    (COL_CYOKUKAISU3)	);	//3蓖x
		dto.setHokaKaisu1 	(rs.getInt    (COL_HOKAKAISU1)	);	//̑x1
		dto.setHokaKaisu2 	(rs.getInt    (COL_HOKAKAISU2)	);	//̑x2
		dto.setHokaKaisu3 	(rs.getInt    (COL_HOKAKAISU3)	);	//̑x3
		dto.setHokaKaisu4 	(rs.getInt    (COL_HOKAKAISU4)	);	//̑x4
		dto.setHokaKaisu5 	(rs.getInt    (COL_HOKAKAISU5)	);	//̑x5
		dto.setSinseiGaku 	(rs.getInt    (COL_SINSEIGAKU)	);	//x\z
		dto.setNijiKyu		(rs.getInt	  (COL_NIJIKYU)		);	//񎞊ԔNx
		dto.setWarimasi1	(rs.getInt	  (COL_WARIMASI1)	);	//1.00
		return dto;
	}

	/**
	 * Sf[^擾
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findAll() throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			prepareStatement(getSelectQuery(getClass()) + getOrderForKey(getClass()));
			executeQuery();
			List all = mappingAll();
			return all;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param kcode ЈR[h
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List findForCondition(
			String kcode,
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_KCODE);
		sb.append(" LIKE ? AND ");
		sb.append(COL_SIKYUYM);
		sb.append(" LIKE ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++,   kcode  );
			setParam(index++,   sikyuym   + "%");
			executeQuery();
			List list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂf[^擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKintaiDto findForKey(
			String kcode,
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()));
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
			MKintaiDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param kcode ЈR[h(L[)
	 * @param sikyuym xN(L[)
	 * @return dto (DTO)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public MKintaiDto findForUpdate(
			String kcode,
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			prepareStatement(getSelectQuery(getClass()) + getConditionForKey(getClass()) + getForUpdate());
			setParam(index++, kcode);
			setParam(index++, sikyuym);
			executeQuery();
			MKintaiDto dto = null;
			if (rs.next()) {
				dto = mapping();
				mappingCommonInfo(dto);
			}
			return dto;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * L[ɂsbN擾
	 * @param sikyuym xN(L[)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void findForUpdate(
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getForUpdate());
			setParam(index++, sikyuym);
			executeQuery();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * ɂf[^擾
	 * @param sikyuym xN
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKintaiDto> findForExport(
			String sikyuym
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append(COL_SIKYUYM);
		sb.append(" = ? ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, sikyuym);
			executeQuery();
			List<MKintaiDto> list = mappingAll();
			return list;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param dto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getInsertQuery(getClass()));
			setParams(dto,true);
			executeUpdate();
			chkInsert(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^}
	 * @param 	aryDto }ΏDTO
	 * @return int }()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int insert(MKintaiDto[] aryDto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("INSERT INTO ");
			sb.append(TABLE);
			sb.append("(");
			Field[] fields = getClass().getFields();
			for (int i = 0; i < fields.length; i++) {
				Field field = fields[i];
				String name = field.getName();
				if (name.indexOf("COL_") == 0) {
					sb.append(field.get(null));
					sb.append(", ");
				}
			}
			if (!INSERT_DATE.equals("")) {
				sb.append(INSERT_DATE + ", ");
			}
			if (!INSERT_USER.equals("")) {
				sb.append(INSERT_USER + ", ");
			}
			if (!UPDATE_DATE.equals("")) {
				sb.append(UPDATE_DATE + ", ");
			}
			if (!UPDATE_USER.equals("")) {
				sb.append(UPDATE_USER + ", ");
			}
			sb.delete(sb.length() - 2, sb.length() - 1);
			sb.append(") VALUES");
			for (int a = 0; a < aryDto.length; a++) {
				sb.append("(");
				for (int i = 0; i < fields.length; i++) {
					Field field = fields[i];
					String name = field.getName();
					if (name.indexOf("COL_") == 0) {
						sb.append("?, ");
					}
				}
				if (!INSERT_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!INSERT_USER.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_DATE.equals("")) {
					sb.append("?, ");
				}
				if (!UPDATE_USER.equals("")) {
					sb.append("?, ");
				}
				sb.delete(sb.length() - 2, sb.length());
				sb.append("),");
			}
			sb.delete(sb.length() - 1, sb.length());
			prepareStatement(sb.toString());
			for (int d = 0; d < aryDto.length; d++) {
				setParams(aryDto[d], true);
			}
			executeUpdate();
			chkInsert(aryDto.length);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^XV
	 * @param dto XVΏDTO
	 * @return int XV()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int update(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getUpdateQuery(getClass()));
			setParams(dto, false);
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			executeUpdate();
			chkUpdate(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param dto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKintaiDto dto) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			prepareStatement(getDeleteQuery(getClass()));
			setParam(index++, dto.getKCode());
			setParam(index++, dto.getSikyuYM());
			executeUpdate();
			chkDelete(1);
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param aryDto XVΏDTO
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(MKintaiDto[] aryDto, String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" WHERE (");
			for (int i = 0; i < aryDto.length; i++) {
				sb.append(COL_KCODE);
				sb.append(" = ? OR ");
			}
			sb.delete(sb.length() - 4, sb.length());
			sb.append(") AND ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ?");
			prepareStatement(sb.toString());
			for (int d = 0; d < aryDto.length; d++) {
				setParam(index++, aryDto[d].getKCode());
			}
			setParam(index++, sikyuym);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * f[^폜
	 * @param 	sikyuym	XVΏ۔N
	 * @return int 폜()
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 * @throws MospException
	 */
	public int delete(String sikyuym) throws SQLException, IllegalAccessException, NoSuchFieldException, MospException {
		try {
			index = 1;
			StringBuffer sb = new StringBuffer();
			sb.append("DELETE FROM ");
			sb.append(TABLE);
			sb.append(" ");
			sb.append("WHERE ");
			sb.append(COL_SIKYUYM);
			sb.append(" = ? ");
			prepareStatement(sb.toString());
			setParam(index++, sikyuym);
			executeUpdate();
			return cnt;
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * p[^ݒ
	 * @param dto XVΏDTO
	 * @throws SQLException
	 */
	private void setParams(MKintaiDto dto, boolean isInsert) throws SQLException {
		setParam(index++, dto.getKCode()		);	//ЈR[h
		setParam(index++, dto.getSikyuYM()		);	//xN
		setParam(index++, dto.getSNen()			);	//xN
		setParam(index++, dto.getSTuki()		);	//x
		setParam(index++, dto.getSHi()			);	//x
		setParam(index++, dto.getSNissu()		);	//oΓ
		setParam(index++, dto.getSKaisu()		);	//oΉ
		setParam(index++, dto.getKinmuJi()		);	//Ζ
		setParam(index++, dto.getKyukeiJi()		);	//xe
		setParam(index++, dto.getYukyu()		);	//L
		setParam(index++, dto.getTokuKyu()		);	//ʋx
		setParam(index++, dto.getKekkin()		);	//ʌΓ
		setParam(index++, dto.getSKekkin()		);	//aΓ
		setParam(index++, dto.getDaiKyu()		);	//֋xɓ
		setParam(index++, dto.getFurikae()		);	//U֋xɓ
		setParam(index++, dto.getSonota()		);	//̑xɓ
		setParam(index++, dto.getTiSoKai()		);	//xމ
		setParam(index++, dto.getTiJikan()		);	//xގ
		setParam(index++, dto.getZaJikan()		);	//ʎcƎ
		setParam(index++, dto.getKsJikan()		);	//xcƎ
		setParam(index++, dto.getSnJikan()		);	//[Ζ
		setParam(index++, dto.getKaikin()		);	//FΎ蓖x
		setParam(index++, dto.getSyokujiKaisu()	);	//H蓖x
		setParam(index++, dto.getCyokuKaisu1()	);	//1蓖x
		setParam(index++, dto.getCyokuKaisu2()	);	//2蓖x
		setParam(index++, dto.getCyokuKaisu3()	);	//3蓖x
		setParam(index++, dto.getHokaKaisu1()	);	//̑x1
		setParam(index++, dto.getHokaKaisu2()	);	//̑x2
		setParam(index++, dto.getHokaKaisu3()	);	//̑x3
		setParam(index++, dto.getHokaKaisu4()	);	//̑x4
		setParam(index++, dto.getHokaKaisu5()	);	//̑x5
		setParam(index++, dto.getSinseiGaku()	);	//x\z
		setParam(index++, dto.getNijiKyu()		);	//񎞊ԔNx
		setParam(index++, dto.getWarimasi1()	);	//1.00
		setCommonParams(isInsert);
	}

	/**
	 * e[ubN
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * e[ubN
	 * @param	kCode	ЈR[h
	 * @param 	sikyuYM	XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(String kCode, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				findForUpdate(kCode, sikyuYM);
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

	/**
	 * e[ubN
	 * @param	listMKintai	DTO
	 * @param 	sikyuYM		XVΏ۔N
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void tableLock(List<MKintaiDto> listMKintai, String sikyuYM) throws SQLException, IllegalAccessException, NoSuchFieldException {
		try {
			if (conn.getMetaData().getDatabaseProductName().equals("MySQL")) {
				// DBMySQL̏ꍇ͍sbN
				for (Iterator iter = listMKintai.iterator(); iter.hasNext();) {
					MKintaiDto dto = (MKintaiDto)iter.next();
					findForUpdate(dto.getKCode(), sikyuYM);
				}
			} else {
				// DBPostgreSQL̏ꍇ̓e[ubN
				StringBuffer sb = new StringBuffer();
				sb.append("LOCK TABLE ");
				sb.append(TABLE);
				prepareStatement(sb.toString());
				executeUpdate();
			}
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}

}
